<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php hooks()->do_action('head_element_client'); ?>
<h4 class="tw-mt-0 tw-mb-3 tw-font-semibold tw-text-lg tw-text-neutral-700 section-heading section-heading-projects">
    <?php echo _l('fe_assets'); ?>
</h4>

<div class="panel_s">
    <div class="panel-body">
        <table class="table dt-table table-projects" data-order-col="2" data-order-type="desc">
            <thead>
                <tr>
                    <th><?php echo _l('fe_asset_name'); ?></th>
                    <th><?php echo _l('fe_serial'); ?></th>
                    <th><?php echo _l('fe_order_number'); ?></th>
                    <th><?php echo _l('fe_order_date'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($asset_list as $asset) { ?>
                <tr>
                    <td><?php echo fe_htmldecode($asset['assets_name']); ?>
                    <?php if($asset['type'] == 'booking'){ ?>
                        &nbsp;&nbsp;&nbsp;&nbsp;<span class="badge badge-primary"><?php echo _l('fe_booking') ?></span>
                    <?php } ?>
                </td>
                    <td><?php echo fe_htmldecode($asset['series']); ?></td>
                    <td>
                        <a href="<?php echo site_url('fixed_equipment/fixed_equipment_client/view_order_detail/' . $asset['order_number']); ?>"><?php echo fe_htmldecode($asset['order_number']); ?></a>
                    </td>
                    <td><?php echo _d($asset['datecreator']); ?></td>
                  <td
                  
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>
<?php hooks()->do_action('client_pt_footer_js'); ?>




