<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Apiseal extends MY_Controller {

	var $secure = FALSE;
	var $api = TRUE;
	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
        $this->load->model('overburden/overburden_model');
        $this->load->model('master/vehicle_model');
	}
	
	public function index()
	{
		// echo phpinfo();
        $this->success('OK');
	}

    public function uploadOverburden()
    {
        $raw_data = file_get_contents('php://input');
        $content = utf8_encode($raw_data);
        $data=json_decode($content,true);
        
        foreach($data as $row){
            $vehicle = $this->vehicle_model->get(array("vehicle_id" => $row['vehicle_id']));

            $ob_data = array();
            $ob_data['over_burden_number'] = $row['overburden_number'];
            $ob_data['over_burden_date'] = $row['overburden_date'];
            $ob_data['over_burden_time'] = $row['overburden_time'];
            $ob_data['vehicle_id'] = $row['vehicle_id'];
            $ob_data['vehicle_number'] = $vehicle['vehicle_number'];
            $ob_data['default_weight'] = $vehicle['default_weight'];
            $ob_data['vendor_id'] = $vehicle['vendor_id'];
            $ob_data['ob_month'] = date("n",strtotime($row['overburden_date']));
            $ob_data['ob_month_name'] = date("F",strtotime($row['overburden_date']));
            $ob_data['ob_day'] = date("d",strtotime($row['overburden_date']));
            $ob_data['ob_hour'] = date("H",strtotime($row['overburden_time']));

            $save = $this->overburden_model->save($ob_data);
            // echo "overburden number : ".."<br>";  echo "overburden date : ".$row['']."<br>"; echo "overburden time : ".$row['']."<br>";
            // echo "device id : ".$row['device_id']."<br>";  echo "vehicle id : ".$row['']."<br>";  echo "<hr>";
        }

        if ($save) {
            $response = array(
                'status' => 1,
                'message' => 'Success'
             );
        } else {
            $response = array(
                'status' => 0,
                'message' => 'Failed'
             );
        } 

        header('Content-Type: application/json');
        echo json_encode($response);
    }

    public function postWeight()
    {
        $this->load->model('master/weight_tmp_model');
        $raw_data = file_get_contents('php://input');
        $content = utf8_encode($raw_data);
        $dataapi=json_decode($content,true);
        
        // foreach($data as $row){
            // $data = array();
            $data['id'] = 1;
            $data['weight'] = $dataapi['berat'];
            $data['last_update'] = $dataapi['timestamp'];
            $save = $this->weight_tmp_model->save($data);
        // }

        if ($save) {
            $response = array(
                'status' => 1,
                'message' => 'Success'
             );
        } else {
            $response = array(
                'status' => 0,
                'message' => 'Failed'
             );
        } 

        // $response = $weight;
        // $response = array(
        //     'weight' => $weight
        //     );

        header('Content-Type: application/json');
        echo json_encode($response);
    }

    public function getFromWeight_()
	{
		$weight = $this->postWeight();
		$this->result['weight'] = $weight;
		$this->success('ok');
	}

}