<div class="wrapper wrapper-content">
    <div class="row">
        <div class="ibox float-e-margins">
            <div class="col-lg-12">
                <div class="ibox-title">
                    <span style="height: 25px;" class="label label-danger "><h5>HAULING DASHBOARD</h5></span>
                </div>
                <div class="ibox-content">
                    <div class="row">
                        <form autocomplete="off" method="post" id="form_filter" class="form-horizontal">
                            <div class="col-lg-4">
                                <div class="row">
                                    <div class="form-group" id="daterange">
                                        <label class="col-sm-2 control-label">Periode</label>    
                                        <div class="col-sm-8">
                                            <div class="input-daterange input-group col-sm-12" id="datepicker">
                                                <input id="filter_date_start" type="text" class="input-sm form-control" name="t_filter_date_start" value="01<?= date('-m-Y') ?>" />
                                                <span class="input-group-addon">to</span>
                                                <input id="filter_date_end" type="text" class="input-sm form-control" name="t_filter_date_end" value="<?= date('d-m-Y') ?>" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2">
                                            <button class="btn btn-success btn-xs" type="button" onclick="refreshData();"><i class="fa fa-search"></i> Refresh</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div id="resultSummary" ></div>
                                </div>                                
                            </div>
                            <div class="col-lg-1">
                                <!-- <div class="form-group">
                                    <button class="btn btn-success btn-xs refreshBtn pull-left" type="button" onclick="refreshData();"><i class="fa fa-search"></i> Refresh</button>
                                </div> -->
                            </div>   
                            <div class="col-lg-7">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="checkbox-inline"><label> <input type="radio" value="month" name="chart_type"> <i></i> By Month </label></div>
                                        <div class="checkbox-inline"><label> <input type="radio" value="day" name="chart_type" checked> <i></i> By Day </label></div>
                                        <div class="checkbox-inline"><label> <input type="radio" value="hour" name="chart_type"> <i></i> By Hour </label></div>
                                        <input id="ch_type" name="t_ch_type" hidden></input> 
                                    </div>
                                </div>
                                <div class="row">
                                    <div id="resultChart" ></div>
                                </div>
                            </div>
                        </form>                         
                    </div>
                </div>
            </div>            
        </div>
    </div> <br>
    <div class="row">
        <div class="ibox float-e-margins">
            <div class="col-lg-6">
                <div class="ibox-title">
                    <h5>By Volume (Ton's)</h5>
                </div>
                <div class="ibox-content">   
                    <div id="resultTable1" ></div>
                </div>
            </div>            
            <div class="col-lg-6">
                <div class="ibox-title">
                    <h5>By Traffict (Vehicles)</h5>
                </div>
                <div class="ibox-content">
                    <div id="resultTable2" ></div>
                </div>
            </div>            
        </div>        
    </div> <br>
    <div class="row">
        <div class="ibox float-e-margins">
            <div class="col-lg-12">
                <div class="ibox-title">
                    <h5>Alokasi Stock Buyer</h5>
                </div>
                <div class="ibox-content">   
                    <div class="row">
                        <div class="col-lg-8">
                            <div id="resultTableAlokasiBuyer" ></div>
                        </div>
                    </div>
                </div>
            </div>           
        </div>        
    </div> <br>
</div>

<script>
    $(document).ready(function(){
        loadSummary();        
        loadChart();
        loadTable1();
        loadTable2();
        loadTableAlokasiBuyer();

        $('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
        });

        $("input[name='chart_type']").change(function(){
            chart_type = $("input[type='radio'][name='chart_type']:checked").val();
            $('#ch_type').val(chart_type);
            loadChart();
        });
    });

    function loadSummary(){
        var formData = $('#form_filter').serializeArray();
        $.ajax({
            url: site_url + "dashboard_hauling/load_summary",
            dataType: "html",
            type: "POST",
            data: formData,
            success: function(result) {
                $('#resultSummary').html(result);                
            }
        })
    };

    function loadChart(){
        // var charttype = $('#ch_type').val(); 
        var formData = $('#form_filter').serializeArray();
        $.ajax({
            url: site_url + "dashboard_hauling/load_chart",
            dataType: "html",
            type: "POST",
            data: formData,
            // data: {
            //     charttype:charttype
            // },
            success: function(result) {
                $('#resultChart').html(result);                
            }
        })
    };

    function loadTable1(){
        $.ajax({
            url: site_url + "dashboard_hauling/load_table1",
            dataType: "html",
            type: "POST",
            data: {
                // ...params
            },
            success: function(result) {
                $('#resultTable1').html(result);                
            }
        })
    };

    function loadTable2(){
        $.ajax({
            url: site_url + "dashboard_hauling/load_table2",
            dataType: "html",
            type: "POST",
            data: {
                // ...params
            },
            success: function(result) {
                $('#resultTable2').html(result);                
            }
        })
    };

    function loadTableAlokasiBuyer(){
        $.ajax({
            url: site_url + "dashboard_hauling/load_table3",
            dataType: "html",
            type: "POST",
            data: {
                // ...params
            },
            success: function(result) {
                $('#resultTableAlokasiBuyer').html(result);                
            }
        })
    };

    function refreshData(){
        loadSummary();
        loadChart();
        loadTable1();
        loadTable2();
        loadTableAlokasiBuyer();
    }
</script>    
