<div class="wrapper wrapper-content animated fadeInRight">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox">
				
            <div class="ibox-title">
                <div class="ibox-tools">
                    <a type="button" class="btn btn_modules_1 loadingButton pull-right btn-xs btn-skin btn-success" href="<?=base_url(uri_string())?>/input/'+000"><i class="fa fa-plus-circle"></i> Create New</a> 
                </div>
            </div>

				<div class="ibox-content">
					<div class="clients-list">

						<div class="table-responsive ">
							<table id="clientDataTable" class="table table-striped table-bordered table-hover" style="width:100%;">
								<thead>
									<tr>
                                        <th>Stock Room ID</th>
										<th>Warehouse ID</th>
										<th>Vendor Card</th>
										<th>Mine Ratio</th>
										<th>Type</th>
									</tr>
								</thead>
							</table>
						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
	$(document).ready(function() {
		$('#clientDataTable').DataTable({
			'processing': true,
			'serverSide': true,
			'serverMethod': 'post',
			'ajax': {
				'url': site_url + "master/stockroom/listPage",
				'data': function(d) {}
			},
			"columnDefs": [{
					"render": function(data, type, row) {
						return getViewButton(row['stockroom_id']);
					},
					"targets": 0,
					"orderable": true
				},
                {
					"render": function(data, type, row) {
						return row['vendor_id']?(row['vendor_id']+' - '+row['vendor_name']):'-';
					},
					"targets": 2,
					"orderable": true
				},
                {
					"render": function(data, type, row) {
						var res = number_format(row['stockroom_mineratio'], 0, ',', '.');
						return res;
					},
					className: 'text-right',
					"targets": 3,
					"orderable": true
				},		
            ],
			'columns': [{
					data: 'stockroom_id'
				},
				{
					data: 'warehouse_id'
				},
				{
					data: 'vendor_id'
				},
				{
					data: 'stockroom_mineratio'
				},
				{
					data: 'origin_type'
				}
			],
			initComplete: function() {},
		});

	});

	function getViewButton(stockroom_id) {
		return '<a data-style="zoom-in" type="button" class="btn btn_modules_10 btn-xs loadingButton" href="<?= base_url(uri_string()) ?>/input/' + encode(stockroom_id) + '">' + stockroom_id + '</a>'
	}

	function refreshDataTable() {
		$('#clientDataTable').DataTable().ajax.reload(null, false);
	}
</script>