<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Coal_getting_report extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('coal_getting_inbound_model');
		$this->bc->set_title('Coal Getting Report');
		$this->bc->add('Coal Getting',base_url().'coalgetting');
		$this->bc->add('Report',base_url().'coalgetting/coal_getting_report');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'report/main'
		);
		$this->load->view('tpl',$data);
	}

    public function listPage()
	{
		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$filter_vendor 	= $this->input->post('filter_vendor');
		$filter_number 	= $this->input->post('filter_number');
		// $filter_status 	= $this->input->post('filter_status');
		$date_start = validate_input($this->input->post('filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['coal_get_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['coal_get_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($filter_vendor) {
            $where['tbl.vendor_id'] = $filter_vendor;
        }

		if ($filter_number) {
            $where['tbl.coal_get_number'] = $filter_number;
        }

		// if ($filter_status) {
        //     $where['sts.status'] = $filter_status;
        // }

		$where["(
			vnd.vendor_name LIKE '%$searchValue%'
			OR tbl.coal_get_number LIKE '%$searchValue%'
		)"] = NULL;

		$this->coal_getting_inbound_model->set_where($where);
		
		$list_count = $this->coal_getting_inbound_model->count();
		$this->coal_getting_inbound_model->set_limit($rowperpage);
		$this->coal_getting_inbound_model->set_offset($start);
		$this->coal_getting_inbound_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->coal_getting_inbound_model->get_list();
		// echo $this->db->last_query(); die;
			
		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

}