<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Coa extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('coa_model');
		$this->load->model('coa_model');
		$this->bc->add('Master',base_url().'master');
		$this->bc->add('Coa',base_url().'master/coa');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'coa/main'
		);
		$this->load->view('tpl',$data);
	}
	
	public function listPage()
	{
		$draw = $this->input->post('draw')?:0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length')?:0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$isActive = $this->input->post('is_active');
		
		$where = array();
		
		$where["(
			tbl.\"accountParentCode\" ~* '$searchValue'
			OR tbl.\"accountParentName\" ~* '$searchValue'
			OR tbl.\"accountCode\" ~* '$searchValue'
			OR tbl.\"accountName\" ~* '$searchValue'
			OR tbl.\"note\" ~* '$searchValue'
		)"] = NULL;
		
		$this->coa_model->set_where($where);
		
		$list_count = $this->coa_model->count();
		$this->coa_model->set_limit($rowperpage);
		$this->coa_model->set_offset($start);
		$this->coa_model->set_order(array($columnName=>$columnSortOrder));
		$list_data  = $this->coa_model->get_list();
		
		$response = array(
		  "post" => $this->input->post(),
		  "draw" => intval($draw),
		  "iTotalRecords" => $list_count,
		  "iTotalDisplayRecords" => $list_count,
		  "aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function input($encoded_id='')
	{
		$images_list = array();
		$decoded_id = decode($encoded_id);
		$head = $this->coa_model->get($decoded_id);
		// echo $this->db->last_query();
		// print_r($head);
		
		$sub_title = 'New Data';
		if($head['accountCode'])
		{
			$sub_title = 'Modify Data';
		}
		$sub_title = 'New Data';
		$action_new = 1;
		if($head['accountCode'])
		{
			$sub_title = 'Modify Data '.$decoded_id.' ('.$head['accountName'].')';
			$action_new = 0;
		}
		$data = array(
			'content' => 'coa/input'
			,'head' => $head
			,'action_new' => $action_new
		);
		$this->bc->add($sub_title,base_url().'master/coa/'.$encoded_id);

		$this->load->view('tpl',$data);
	}

	public function getCoaParent()
	{
		$result_option = '';
		$this->coa_model->set_order(array('accountParentCode'=>'ASC','accountCode'=>'ASC'));
		$list_combo = $this->coa_model->get_list();
		foreach($list_combo->result_array() as $row)
		{
			$result_option .= '<option value="'.$row['accountCode'].'">'.$row['accountCode']." (".$row['accountName'].")".'</option>';
		}
		
		echo $result_option;
	}

	public function save()
	{
		$action_new = $this->input->post('t_action_new');
    	$data['accountCode'] = trim($this->input->post('t_accountCode'));
    	$data['accountName'] = $this->input->post('t_accountName');
		$data['cash'] = $this->input->post('t_cash')?1:0;
		$data['balanceSheet'] = $this->input->post('t_balanceSheet')?1:0;
		$data['incomeStatement'] = $this->input->post('t_incomeStatement')?1:0;
		$data['operational'] = $this->input->post('t_operational')?1:0;
		$data['investment'] = $this->input->post('t_investment')?1:0;
		$data['funding'] = $this->input->post('t_funding')?1:0;
		$data['note'] = $this->input->post('t_note');
		if($action_new)
		{
			$data['accountParentCode'] = trim($this->input->post('t_accountParentCode'));
			$accountLevel = 1;
			// buat level
			$parent = $this->coa_model->get(array('accountCode'=>$data['accountParentCode']));
			$accountLevel = $parent['accountLevel']+1;
			$data['accountLevel'] = $accountLevel;
			$data['accountParentName'] = $parent['accountName'];

			// cek nomor apakah sudah dipakai jika buat baru
			if(strlen($data['accountCode'])<4)
			$this->error('Kode kurang dari 4 digit');

			$check_bp = $this->coa_model->get(array('accountCode'=>$data['accountCode']));
			if($check_bp['accountCode'])
			$this->error('Kode '.$data['accountCode'].' Sudah digunakan');
		}

		$save = $this->coa_model->save($data);
		$this->result['account_code'] = encode($data['accountCode']);
		$this->success('Simpan Sukses');
	}
}