<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Modal extends MY_Controller
{

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
	}

	public function index()
	{
		getMenuBoxed();
	}

	public function lookupBankCashAccount()
	{
		$transnum = $this->input->post('transnum');
		$data = array(
			'content' => 'modal/bank_cash_account/main'
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupBankCashAccountListPage()
	{
		$this->load->model('master/bank_cash_account_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$where = array();

		$business_unit_code = $this->input->post('business_unit_code') ?: $this->session->userdata('businessUnitCode');

		$where['businessUnitCode'] = $business_unit_code;
		$where["(
			tbl.\"bankAccountCode\" ~* '$searchValue'
			OR tbl.\"bankAccountName\" ~* '$searchValue'
		)"] = NULL;

		$this->bank_cash_account_model->set_where($where);

		$list_count = $this->bank_cash_account_model->count();
		$this->bank_cash_account_model->set_limit($rowperpage);
		$this->bank_cash_account_model->set_offset($start);
		$this->bank_cash_account_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->bank_cash_account_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupBusinessPartner()
	{
		$transnum = $this->input->post('transnum');
		$rolecode = $this->input->post('role_code');
		$data = array(
			'content' => 'modal/business_partner/main',
			'rolecode' => $rolecode
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupBusinessPartnerListPage()
	{
		$this->load->model('master/business_partner_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$rolecode = $this->input->post('role_code');

		$where = array();

		$business_unit_code = $this->input->post('business_unit_code') ?: $this->session->userdata('businessUnitCode');

		if ($rolecode != '') {
			$where['tbl.roleCode'] = $rolecode;
		}

		$where['businessUnitCode'] = $business_unit_code;
		$where["(
			tbl.\"businessPartnerCode\" ~* '$searchValue'
			OR tbl.\"businessPartnerName\" ~* '$searchValue'
			OR tbl.\"address\" ~* '$searchValue'
			OR tbl.\"note\" ~* '$searchValue'
			OR bp.\"roleName\" ~* '$searchValue'
		)"] = NULL;

		$this->business_partner_model->set_where($where);

		$list_count = $this->business_partner_model->count();
		$this->business_partner_model->set_limit($rowperpage);
		$this->business_partner_model->set_offset($start);
		$this->business_partner_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->business_partner_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupRefBankCashOut()
	{
		$transnum = $this->input->post('transnum');
		$dept_code = $this->input->post('dept_code');
		$data = array(
			'content' => 'modal/ref_bank_cash_out/main',
			'dept_code' => $dept_code
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupRefBankCashOutPage()
	{
		$this->load->model('finance/bank_cash_out_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$where = array();

		$business_unit_code = $this->input->post('business_unit_code') ?: $this->session->userdata('businessUnitCode');
		$dept_code = $this->input->post('dept_code');

		$where["(
				tbl.\"transNum\" ~* '$searchValue'
				OR tbl.\"description\" ~* '$searchValue'
				OR tbl.\"tipe_transaksi\" ~* '$searchValue'
				OR tbl.\"employeeCode\" ~* '$searchValue'
				OR tbl.\"projectNum\" ~* '$searchValue'
				OR bpr.\"businessPartnerName\" ~* '$searchValue'
			)"] = NULL;
		$where['tbl."deptCode"'] = $dept_code;

		$this->bank_cash_out_model->set_where($where);

		$list_count = $this->bank_cash_out_model->get_ref_bank_cash_out(0, $business_unit_code);
		$this->bank_cash_out_model->set_limit($rowperpage);
		$this->bank_cash_out_model->set_offset($start);
		$this->bank_cash_out_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->bank_cash_out_model->get_ref_bank_cash_out(1, $business_unit_code);

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupAdvanceRealization()
	{
		$dept_code = $this->input->post('dept_code');
		$data = array(
			'content' => 'modal/advance_realization/main',
			'dept_code' => $dept_code
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupAdvanceRealizationListPage()
	{
		$this->load->model('finance/advance_realization_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$where = array();

		$business_unit_code = $this->input->post('business_unit_code') ?: $this->session->userdata('businessUnitCode');
		$dept_code = $this->input->post('dept_code');

		$where['tbl.businessUnitCode'] = $business_unit_code;
		$where['tbl.totalVarian > 0'] = null;
		$where['tbl."deptCode"'] = $dept_code;
		$where['tbl."tranStatus" >= 3 '] = null;

		$where["(
			tbl.\"description\" ~* '$searchValue'
			OR tbl.\"projectNum\" ~* '$searchValue'
			OR tbl.\"advRealNum\" ~* '$searchValue'
		)"] = NULL;

		$this->advance_realization_model->set_where($where);

		$list_count = $this->advance_realization_model->count();
		$this->advance_realization_model->set_limit($rowperpage);
		$this->advance_realization_model->set_offset($start);
		$this->advance_realization_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->advance_realization_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupPurchaseOrder()
	{
		$unit_bisnis = $this->input->post('unit_bisnis');
		$data = array(
			'content' => 'modal/purchase_order/main',
			'unit_bisnis' => $unit_bisnis
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupPurchaseOrderListPage()
	{
		$this->load->model('finance/vendor_invoice_detail_modal_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$business_unit_code = $this->input->post('business_unit_code') ?: $this->session->userdata('businessUnitCode');

		$where['tbl.businessUnitCode'] = $business_unit_code;
		$where['tbl.tranStatus = 1'] = null;

		$where["(
			tbl.\"businessPartnerCode\" ~* '$searchValue'			
			OR tbl.\"purchaseOrderNumber\" ~* '$searchValue'
			OR bp.\"businessPartnerName\" ~* '$searchValue'
		)"] = NULL;

		$this->vendor_invoice_detail_modal_model->set_where($where);

		$list_count = $this->vendor_invoice_detail_modal_model->count_list_po();
		$this->vendor_invoice_detail_modal_model->set_limit($rowperpage);
		$this->vendor_invoice_detail_modal_model->set_offset($start);
		$this->vendor_invoice_detail_modal_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->vendor_invoice_detail_modal_model->get_po_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupGeneralLedger()
	{
		$trans_num = $this->input->post('trans_num');
		$data = array(
			'content' => 'modal/gen_ledger/main',
			'trans_num' => $trans_num
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupGeneralLedgerListPage()
	{
		$this->load->model('accounting/general_ledger_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$transNum = $this->input->post('trans_num');

		$where['tbl.transNum'] = $transNum;

		$where["(
			tbl.\"accountCode\" ~* '$searchValue'			
			OR tbl.\"accountName\" ~* '$searchValue'
		)"] = NULL;

		$this->general_ledger_model->set_where($where);

		$list_count = $this->general_ledger_model->count();
		$this->general_ledger_model->set_limit($rowperpage);
		$this->general_ledger_model->set_offset($start);
		$this->general_ledger_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->general_ledger_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupBankStatement()
	{
		$amount = $this->input->post('amount');
		$id_bank_reconsile_detail = $this->input->post('id_bank_reconsile_detail');
		$account_number = $this->input->post('account_number');
		$deposit_date = $this->input->post('deposit_date');
		$range = 1000;
		$amount_start = $amount - $range;
		$amount_end = $amount + $range;

		$tgl = new DateTime($deposit_date);
		$deposit_date = $tgl->format('d-m-Y');
		$deposit_date_until = date('d-m-Y', strtotime($deposit_date . ' + 7 days'));

		$data = array(
			'content' => 'modal/bank_statement/main',
			'range' => $range,
			'amount' => $amount,
			'amount_start' => $amount_start,
			'amount_end' => $amount_end,
			'account_number' => $account_number,
			'deposit_date' => $deposit_date,
			'deposit_date_until' => $deposit_date_until,
			'id_bank_reconsile_detail' => $id_bank_reconsile_detail
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupBankStatementListPage()
	{
		$this->load->model('finance/bank_statement_model');
		$account_number = $this->input->post('account_number');
		$amount_start =
			validate_input(
				floatval(preg_replace('/[^\d.]/', '', $this->input->post('amount_start'))),
				array(
					'name' => 'Amount Start',
					'required' => false,
					'type' => 'int'
				)
			);
		$amount_end =
			validate_input(
				floatval(preg_replace('/[^\d.]/', '', $this->input->post('amount_end'))),
				array(
					'name' => 'Amount End',
					'required' => false,
					'type' => 'int'
				)
			);
		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 10;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		// $transnum = $this->input->post('transnum');
		// $ref_num = $this->input->post('ref_num');
		// print_r($filter_status);
		$deposit_date_start = $this->input->post('deposit_date_start');
		$deposit_date_end = $this->input->post('deposit_date_end');

		$where = array();

		if ($deposit_date_start) {
			$where['tbl."transDate" >=' . quotedStr(getSQLDate($deposit_date_start))] = null;
		}
		if ($deposit_date_end) {
			$where['tbl."transDate" <=' . quotedStr(getSQLDate($deposit_date_end))] = null;
		}

		$where['amount >= ' . $amount_start] = null;
		$where['amount <= ' . $amount_end] = null;
		// $where['"amount" BETWEEN ' . quotedstr($amount_start) . ' AND ' . quotedstr($amount_end) . ''] = null;

		if ($account_number != '')
			$where['tbl.accountNumber'] = $account_number;

		$where['("refTransaction" IS NULL OR "refTransaction" = \'\') '] = null;

		$where["(
			tbl.\"accountName\" ~* '$searchValue'
			or tbl.\"description\" ~* '$searchValue'
		)"] = NULL;

		$this->bank_statement_model->set_where($where);

		$list_count = $this->bank_statement_model->count();
		$this->bank_statement_model->set_limit($rowperpage);
		$this->bank_statement_model->set_offset($start);
		$this->bank_statement_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->bank_statement_model->get_list();
		// echo $this->db->last_query();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupMasterProduct()
	{
		// $transnum = $this->input->post('transnum');
		$data = array(
			'content' => 'modal/master_product/main'
		);
		$this->load->view($data['content'], $data);
	}

	public function lookupMasterProductListPage()
	{
		// $this->load->model('beon/beon_master_product_model');
		$this->load->model('mms/item_master_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$where["(
			tbl.\"ItemCode\" ~* '$searchValue'
			OR tbl.\"ItemName\" ~* '$searchValue'
		)"] = NULL;

		$this->item_master_model->set_where($where);

		$list_count = $this->item_master_model->count();
		$this->item_master_model->set_limit($rowperpage);
		$this->item_master_model->set_offset($start);
		$this->item_master_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->item_master_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function lookupCrudCategory($id_item_group)
	{
		$this->load->model('mms/item_group_model');
		$data = array(
			'content' => 'modal/crud_category/main',
			'id_item_group' => $id_item_group
		);

		$this->load->view($data['content'],$data);
	}

	public function crudCategoryListPage()
	{
		$id_item_group = $this->input->post('id_item_group');
		$this->load->model('mms/category_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$where['fItemGroup'] = $id_item_group;
		$where["(
			tbl.\"Description\" ~* '$searchValue'
		)"] = NULL;

		$this->category_model->set_where($where);

		$list_count = $this->category_model->count();
		$this->category_model->set_limit($rowperpage);
		$this->category_model->set_offset($start);
		$this->category_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->category_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function saveCrudCategory()
	{
		if($this->input->post('id_item_group') == 'null')
		$this->error('Item Group belum dipilih');

		$save_msg = 'Update Data';
		$this->load->model('mms/category_model');

		$data['IdCategory'] = $this->input->post('id_category');
		$data['Description'] = $this->input->post('category_description');
		$data['fItemGroup'] = $this->input->post('id_item_group');
		if($data['IdCategory']==0)
		{
			$save_msg = 'Create Data';
			$data['IdCategory'] = $this->category_model->get_last_id_category($data['fItemGroup'])+1;
		}
		
		$this->db->trans_start();
		
		$this->category_model->save($data);

		$this->db->trans_complete();
		
		if ($this->db->trans_status() === false)
		{
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		}else{
			$this->db->trans_commit();
			$this->success($save_msg.' Success');
		}
	}
	
	public function lookupCrudMclass($id_item_group, $id_category)
	{
		$data = array(
			'content' => 'modal/crud_mclass/main',
			'id_item_group' => $id_item_group,
			'id_category' => $id_category
		);

		$this->load->view($data['content'],$data);
	}

	public function crudMclassListPage()
	{
		$id_item_group = $this->input->post('id_item_group');
		$id_category = $this->input->post('id_category');
		$this->load->model('mms/m_class_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$where['fItemGroup'] = $id_item_group;
		$where['fIdCategory'] = $id_category;
		$where["(
			tbl.\"Description\" ~* '$searchValue'
		)"] = NULL;

		$this->m_class_model->set_where($where);

		$list_count = $this->m_class_model->count();
		$this->m_class_model->set_limit($rowperpage);
		$this->m_class_model->set_offset($start);
		$this->m_class_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->m_class_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function saveCrudMclass()
	{
		if($this->input->post('id_item_group') == 'null')
		$this->error('Item Group belum dipilih');
		if($this->input->post('id_category') == 'null')
		$this->error('Category belum dipilih');

		$save_msg = 'Update Data';
		$this->load->model('mms/m_class_model');

		$data['IdMclass'] = $this->input->post('id_mclass');
		$data['fIdCategory'] = $this->input->post('id_category');
		$data['Description'] = $this->input->post('mclass_description');
		$data['fItemGroup'] = $this->input->post('id_item_group');
		if($data['IdMclass']==0)
		{
			$save_msg = 'Create Data';
			$data['IdMclass'] = $this->m_class_model->get_last_id_mclass($data['fItemGroup'],$data['fIdCategory'])+1;
		}
		
		$this->db->trans_start();
		
		$this->m_class_model->save($data);

		$this->db->trans_complete();
		
		if ($this->db->trans_status() === false)
		{
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		}else{
			$this->db->trans_commit();
			$this->success($save_msg.' Success');
		}
	}

	function lookupCrudSeason()
	{
		$data = array(
			'content' => 'modal/crud_season/main'
		);

		$this->load->view($data['content'],$data);
	}
	
	public function crudSeasonListPage()
	{
		$this->load->model('mms/season_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$where["(
			tbl.\"Description\" ~* '$searchValue'
		)"] = NULL;

		$this->season_model->set_where($where);

		$list_count = $this->season_model->count();
		$this->season_model->set_limit($rowperpage);
		$this->season_model->set_offset($start);
		$this->season_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->season_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function saveCrudSeason()
	{
		$save_msg = 'Update Data';
		$this->load->model('mms/season_model');

		$action_type = $this->input->post('action_type');
		$data['IdSeason'] = $this->input->post('id_season');
		$data['Description'] = $this->input->post('season_description');
		$data['FromDate'] = $this->input->post('from_date');
		$data['ToDate'] = $this->input->post('to_date');
		
		if($this->input->post('from_date') == '')
		$data['FromDate'] = null;
		if($this->input->post('to_date') == '')
		$data['ToDate'] = null;
		
		if($action_type==0)
		{
			$save_msg = 'Create Data';
			$check_id = $this->season_model->get(array('IdSeason'=>$data['IdSeason']));
			if($check_id['IdSeason'])
			$this->error('Id Season '.$data['IdSeason'].' sudah dipakai ['.$check_id['Description'].']');
		}

		if(!$data['IdSeason'])
		$this->error('Id Season is empty!');
		
		$this->db->trans_start();
		$this->season_model->set_clean_data(false);
		$this->season_model->save($data);

		$this->db->trans_complete();
		
		if ($this->db->trans_status() === false)
		{
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		}else{
			$this->db->trans_commit();
			$this->success($save_msg.' Success');
		}
	}

	public function lookupCrudStyle($id_item_group, $id_category, $id_mclass)
	{
		$data = array(
			'content' => 'modal/crud_style/main',
			'id_item_group' => $id_item_group,
			'id_category' => $id_category,
			'id_mclass' => $id_mclass
		);

		$this->load->view($data['content'],$data);
	}

	public function crudStyleListPage()
	{
		$id_item_group = $this->input->post('id_item_group');
		$id_category = $this->input->post('id_category');
		$id_mclass = $this->input->post('id_mclass');
		$this->load->model('mms/style_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$where['fItemGroup'] = $id_item_group;
		$where['fIdCategory'] = $id_category;
		$where['fIdMclass'] = $id_mclass;
		$where["(
			tbl.\"Description\" ~* '$searchValue'
		)"] = NULL;

		$this->style_model->set_where($where);

		$list_count = $this->style_model->count();
		$this->style_model->set_limit($rowperpage);
		$this->style_model->set_offset($start);
		$this->style_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->style_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function saveCrudStyle()
	{
		if($this->input->post('id_item_group') == 'null')
		$this->error('Item Group belum dipilih');
		if($this->input->post('id_category') == 'null')
		$this->error('Category belum dipilih');
		if($this->input->post('id_mclass') == 'null')
		$this->error('M-Class belum dipilih');

		$save_msg = 'Update Data';
		$this->load->model('mms/style_model');

		$data['IdStyle'] = $this->input->post('id_style');
		$data['fIdCategory'] = $this->input->post('id_category');
		$data['fIdMclass'] = $this->input->post('id_mclass');
		$data['Description'] = $this->input->post('style_description');
		$data['fItemGroup'] = $this->input->post('id_item_group');
		if($data['IdStyle']==0)
		{
			$save_msg = 'Create Data';
			$data['IdStyle'] = $this->style_model->get_last_id_style($data['fItemGroup'],$data['fIdCategory'],$data['fIdMclass'])+1;
		}
		
		$this->db->trans_start();
		
		$this->style_model->save($data);

		$this->db->trans_complete();
		
		if ($this->db->trans_status() === false)
		{
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		}else{
			$this->db->trans_commit();
			$this->success($save_msg.' Success');
		}
	}
	
	public function lookupCrudArticle($id_item_group, $id_category, $id_mclass, $id_style)
	{
		$data = array(
			'content' => 'modal/crud_article/main',
			'id_item_group' => $id_item_group,
			'id_category' => $id_category,
			'id_mclass' => $id_mclass,
			'id_style' => $id_style
		);

		$this->load->view($data['content'],$data);
	}

	public function crudArticleListPage()
	{
		$id_item_group = $this->input->post('id_item_group');
		$id_category = $this->input->post('id_category');
		$id_mclass = $this->input->post('id_mclass');
		$id_style = $this->input->post('id_style');
		$this->load->model('mms/article_model');

		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value

		$where = array();
		$where['fItemGroup'] = $id_item_group;
		$where['fIdCategory'] = $id_category;
		$where['fIdMclass'] = $id_mclass;
		$where['fIdStyle'] = $id_style;
		$where["(
			tbl.\"Description\" ~* '$searchValue'
		)"] = NULL;

		$this->article_model->set_where($where);

		$list_count = $this->article_model->count();
		$this->article_model->set_limit($rowperpage);
		$this->article_model->set_offset($start);
		$this->article_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->article_model->get_list();

		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

	public function saveCrudArticle()
	{
		if($this->input->post('id_item_group') == 'null')
		$this->error('Item Group belum dipilih');
		if($this->input->post('id_category') == 'null')
		$this->error('Category belum dipilih');
		if($this->input->post('id_mclass') == 'null')
		$this->error('M-Class belum dipilih');
		if($this->input->post('id_style') == 'null')
		$this->error('Style belum dipilih');

		$save_msg = 'Update Data';
		$this->load->model('mms/article_model');

		$data['IdArticle'] = $this->input->post('id_article');
		$data['fIdCategory'] = $this->input->post('id_category');
		$data['fIdMclass'] = $this->input->post('id_mclass');
		$data['fIdStyle'] = $this->input->post('id_style');
		$data['Description'] = $this->input->post('article_description');
		$data['fItemGroup'] = $this->input->post('id_item_group');
		if($data['IdArticle']==0)
		{
			$save_msg = 'Create Data';
			$data['IdArticle'] = $this->article_model->get_last_id_article($data['fItemGroup'],$data['fIdCategory'],$data['fIdMclass'],$data['fIdStyle'])+1;
		}
		
		$this->db->trans_start();
		
		$this->article_model->save($data);

		$this->db->trans_complete();
		
		if ($this->db->trans_status() === false)
		{
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		}else{
			$this->db->trans_commit();
			$this->success($save_msg.' Success');
		}
	}
}
