<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Customer_billing extends Db_update_model {
	function __construct() {
        $this->schema = 'facc';
        parent::__construct();
        // $this->run();
    }
    function run($forge=null){
        $this->forge = $forge;
        $this->customerBilling();
        $this->customerBillingDetail();
    }
    
    function customerBilling(){
        $this->table = 'customerBilling';
        $this->fields = array(
                'transNum' => array(
                        'type' => 'varchar',
                        'constraint' => 50,
                        'default' => '0',
                        'key' => TRUE
                ),
                'businessUnitCode' => array(
                        'type' => 'varchar',
                        'constraint' => '20',
                        'unsigned' => TRUE,
                ),
                'businessPartnerCode' => array(
                        'type' => 'varchar',
                        'constraint' => '20',
                        'unsigned' => TRUE,
                ),
                'description' => array(
                        'type' => 'text',
                        'unsigned' => TRUE,
                ),
                'currency' => array(
                        'type' => 'varchar',
                        'constraint' => 5,
                        'unsigned' => TRUE,
                ),
                'billingDate' => array(
                        'type' => 'date',
                        'unsigned' => TRUE,
                ),
                'dueDateOldest' => array(
                        'type' => 'date',
                        'unsigned' => TRUE,
                ),
                'dueDateLastest' => array(
                        'type' => 'date',
                        'unsigned' => TRUE,
                ),
                'totalBilling' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'unsigned' => TRUE,
                ),
                'totalBillingPayment' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'unsigned' => TRUE,
                ),
                'totalSaldoBilling' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'unsigned' => TRUE,
                        'comment' => 'saldo billing'
                ),
                'tranStatus' => array(
                        'type' => 'integer',
                        'unsigned' => TRUE,
                ),
                'createdBy' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'createdDate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'modifBy' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'modifDate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'approveBy' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'approveDate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'approveStatus' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'lastUpdate' => array(
                        'type' => 'timestamp',
                        'default' => 'now()'
                ),
                'invoiceCount' => array(
                        'type' => 'integer',
                        'default' => '0'
                ),
                'commitmentPayment' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'default' => '0',
                        'comment' => 'total pembayaran yg diajukan oleh mitra'
                ),
                'subTotal' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'default' => '0',
                        'comment' => 'total gross'
                ),
                'discountTotal' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'default' => '0',
                        'comment' => 'total discount'
                ),
                'grandTotal' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'default' => '0',
                        'comment' => 'total tagihan'
                ),
                'totalPaid' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'default' => '0',
                        'comment' => 'total pembayaran dari invoice yg terdaftar'
                ),
                'closedDate' => array(
                        'type' => 'timestamp',
                        'default' => '0',
                        'comment' => 'total pembayaran dari invoice yg terdaftar'
                ),
                'totalBillingOverDue' => array(
                        'type' => 'numeric',
                        'constraint' => '20,2',
                        'default' => '0',
                        'comment' => 'total billing yg sudah jatuh tempo'
                ),
                'bankAccountCode' => array(
                        'type' => 'varchar',
                        'constraint' => '10',
                        'default' => '',
                        'comment' => 'Kode bank yg dipilih'
                ),
                'paymentDate' => array(
                        'type' => 'date',
                        'unsigned' => TRUE,
                ),

        );
        $this->build();
    }

    function customerBillingDetail(){
        $this->table = 'customerBillingDetail';
        $this->fields = array(
                'transNum' => array(
                        'type' => 'varchar',
                        'constraint' => 50,
                        'default' => '0',
                        'key' => TRUE
                ),
                'recNum' => array(
                        'type' => 'integer',
                        'unsigned' => TRUE,
                ),
                'invoiceNumber' => array(
                        'type' => 'varchar',
                        'constraint' => '40',
                        'unsigned' => TRUE,
                        'key' => TRUE
                ),
                'invoiceDate' => array(
                        'type' => 'date',
                        'unsigned' => TRUE,
                ),
                'dueDate' => array(
                        'type' => 'date',
                        'unsigned' => TRUE,
                ),
                'grandTotal' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'default' => '0',
                        'unsigned' => TRUE,
                ),
                'totalPaid' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'default' => '0',
                        'unsigned' => TRUE,
                ),
                'saldo' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'default' => '0',
                        'unsigned' => TRUE,
                ),
                'commitmentPayment' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'default' => '0',
                        'unsigned' => TRUE,
                        'comment' => 'commitmen payment yg diajukan'
                ),
                'confirmedPayment' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'default' => '0',
                        'unsigned' => TRUE,
                        'comment' => 'payment confirmed by team AR'
                ),
                'subTotal' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'default' => '0',
                        'unsigned' => TRUE,
                ),
                'discountTotal' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'default' => '0',
                        'unsigned' => TRUE,
                ),
                'saldoBilling' => array(
                        'type' => 'numeric',
                        'constraint' => '18,2',
                        'unsigned' => TRUE,
                        'default' => '0',
                        'comment' => 'saldo billing setelah dikurangin payment'
                ),

        );
        $this->build();           
    }
}