<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mining_recap extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('mining_model');
		$this->load->model('mining_recap_model');
		$this->bc->set_title('Mining Recap');
		$this->bc->add('Mining',base_url().'hauling');
		$this->bc->add('Recap',base_url().'hauling/mining_recap');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'mining/main'
		);
		$this->load->view('tpl',$data);
	}

    public function load_mining_process()
	{
		
		$data = array(
			'content' => 'mining/process',
		);
		$this->load->view($data['content'], $data);
	}

	public function load_mining_report()
	{
		
		$data = array(
			'content' => 'mining/report',
		);
		$this->load->view($data['content'], $data);
	}

    public function listPageProcess()
	{
		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$filter_vendor 	= $this->input->post('filter_vendor');
		$date_start = validate_input($this->input->post('filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['mine_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['mine_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($filter_vendor){
			$where['tbl.vendor_id'] = $filter_vendor;
		}

		$where["(
			tbl.mine_number LIKE '%$searchValue%'
			OR tbl.vehicle_id LIKE '%$searchValue%'
			OR tbl.vehicle_number LIKE '%$searchValue%'
			OR sts.status LIKE '%$searchValue%'
		)"] = NULL;

		$this->mining_model->set_where($where);
		
		$list_count = $this->mining_model->count();
		$this->mining_model->set_limit($rowperpage);
		$this->mining_model->set_offset($start);
		$this->mining_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->mining_model->get_list();
		// echo $this->db->last_query(); die;
			
		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

    public function listPageReport()
	{
		$draw = $this->input->post('draw') ?: 0;
		$start = $this->input->post('start');
		$rowperpage  = $this->input->post('length') ?: 0;
		$columnIndex   = $_POST['order'][0]['column'];
		$columnName    = $_POST['columns'][$columnIndex]['data'];
		$columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
		$searchValue = $_POST['search']['value']; // Search value
		$filter_vendor 	= $this->input->post('filter_vendor');
		$date_start = validate_input($this->input->post('filter_date_start'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('filter_date_end'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['mine_recapdate >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['mine_recapdate <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($filter_vendor){
			$where['tbl.vendor_id'] = $filter_vendor;
		}

		$where["(
			tbl.mine_recapnum LIKE '%$searchValue%'
            OR sts.status LIKE '%$searchValue%'
		)"] = NULL;

		$this->mining_recap_model->set_where($where);
		
		$list_count = $this->mining_recap_model->count();
		$this->mining_recap_model->set_limit($rowperpage);
		$this->mining_recap_model->set_offset($start);
		$this->mining_recap_model->set_order(array($columnName => $columnSortOrder));
		$list_data  = $this->mining_recap_model->get_list();
		// echo $this->db->last_query(); die;
			
		$response = array(
			"post" => $this->input->post(),
			"draw" => intval($draw),
			"iTotalRecords" => $list_count,
			"iTotalDisplayRecords" => $list_count,
			"aaData" => $list_data->result_array()
		);

		header('Content-type: application/json');
		echo json_encode($response);
	}

    function recap_data()
    {
        $filter_vendor 	= $this->input->post('t_filter_vendor_process');
		$date_start = validate_input($this->input->post('t_filter_date_start_process'),
            array(
                'name' => 'Date Start',
                'required' => true,
                'type' => 'date',
            )
        );
		$date_end = validate_input($this->input->post('t_filter_date_end_process'),
            array(
                'name' => 'Date End',
                'required' => true,
                'type' => 'date',
            )
        );
		$filter_date_start 	= getSQLDate($date_start);
		$filter_date_end 	= getSQLDate($date_end);

		$where = array();

		if ($filter_date_start) {
			$where['mine_date >= ' . quotedStr($filter_date_start) . ''] = null;
		}
		if ($filter_date_end) {
			$where['mine_date <= ' . quotedStr($filter_date_end) . ''] = null;
		}

		if ($filter_vendor){
			$where['tbl.vendor_id'] = $filter_vendor;
		}

        $where['tbl.mine_status'] = 1;

        $this->mining_model->set_where($where);
        $mining_recap_data = $this->mining_model->get_list_summary();
        
        $this->db->trans_start();

        if ($mining_recap_data->num_rows() > 0){
			foreach($mining_recap_data->result_array() as $row)
			{
                $prefix =  date('y') . date('m')  . '.MIR.';
                $transnum = $this->mining_recap_model->gen_transaction_number($prefix);
                $vendor = $row['vendor_id'];

				$data_detail					 = array();
				$data_detail['mine_recapnum']	 = $transnum;
				$data_detail['vendor_id']	 	 = $row['vendor_id'];
				$data_detail['net_weight'] 		 = $row['net_weight'];
				$data_detail['mine_recapdate']	 = date('Y-m-d');
				$data_detail['mine_recapstatus'] = 3;
				// simpan detail
                
				$save = $this->mining_recap_model->save($data_detail);

                if($save){
                    $this->mining_model->update_header($transnum,$filter_date_start,$filter_date_end,$vendor);
                }
			}
		}

        $this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->success('Simpan Berhasil');
		}
    }

    public function print_doc_pdf($p_transnum='',$debug=0)
	{
		// $this->load->model('master/business_unit_model');
		// $this->load->model('master/warehouse_model');

		// $ponumber = $this->input->get('transnum')?:decode($p_transnum);

		// $data_header = $this->purchase_order_model->get($ponumber);
		// $opr = $this->operator_model->get($data_header['createdBy']);

		// $where_detail= array();
		// $where_detail['poNumber'] = $ponumber;
		// $this->purchase_order_item_model->set_where($where_detail);
		// $this->purchase_order_item_model->set_order(array("recNum" => "ASC"));
		// $data_detail = $this->purchase_order_item_model->get_list();

		// $sum_qty = $this->purchase_order_item_model->sum_qty_po($ponumber);
		
		// $business_unit = $this->business_unit_model->get($data_header['businessUnitCode']);
		// $ship_to = $this->warehouse_model->get(array('warehouseCode' => $data_header['shipTo'], 'businessUnitCode' => $data_header['businessUnitCode']));

		// $barcode_link = generate_barcode($ponumber);

		// $status_approve = $data_header['approvedStatus'];
		// if($status_approve == 'Y')
		// {
		// 	$print_title = 'PURCHASE ORDER';
		// } else {
		// 	$print_title = 'PROFORMA PURCHASE ORDER';
		// }

		$data = array(
			'content' 			=> 'mining/detail_print_pdf', 
			// 'barcode_link'		=> $barcode_link,
			// 'ponumber'			=> $ponumber,
			// 'data_header'		=> $data_header,
			// 'data_detail'		=> $data_detail,
			// 'debug'				=> $debug,
			// 'business_unit'		=> $business_unit,
			// 'operator'			=> $opr,
			// 'print_title'		=> $print_title,
			// 'ship_name'			=> $ship_to,
			// 'sum_qty'			=> $sum_qty
		);

		$option = array(
			'paper_size' => 'A4' 
		);

		$this->load_pdf($data['content'], $data, $option);
	}
}