<div class="table-responsive ">
    <table id="listDataTableProduct" class="table table-striped table-bordered table-hover" style="width:100%;">
        <thead>
            <tr>
                <th style="width:15%">Item Code</th>
                <th style="width:35%">Description</th>
                <th style="width:15%">Purchase Price</th>
                <th style="width:15%">Selling Price</th>
                <th style="width:5%">UoM</th>
                <th style="text-align:center; width:15%">Action</th>
            </tr>
        </thead>
    </table>
</div>

<script type="text/javascript">
$(document).ready(function() {
	$('#form_filter').submit(function(e) {
		console.log(e);
		refreshDataTable();
		e.preventDefault();
	});

	var	listDataTableProduct = $('#listDataTableProduct')
			.on('preXhr.dt', function(e, settings, data) {
				$('.browseBtn').ladda('start');
			}).DataTable({
				"lengthMenu": [
					[10, 25, 50, -1],
					[10, 25, 50, "All"]
				],
				'processing': true,
				'serverSide': true,
                'responsive': true,
                'serverMethod': 'post',
                'ajax': {
                    'async': true,
                    'url': site_url + "main/modal/lookupMasterProductListPage",
                    'beforeSend': function(xhr) {},
                    'data': function(d) { },
                    'error': function(jqXhr, textStatus, errorThrown) {
                        var error_message = 'internal error';
                        if (jqXhr.responseJSON !== undefined) {
                            error_message = jqXhr['responseJSON']['message'];
                        }
                        swal.fire('error', error_message, "error");
                        $('.browseBtn').ladda('stop');
                    }
                },
                'dom': '<"html5buttons"B>lTfg<"PrintArea"tr><"row"<"col-sm-5"i><"col-sm-7"p>>',
                "columnDefs": [
                    {
                        "render": function(data, type, row) {
                            return number_format(row['PurchasePrice'], 2, ',', '.');
                        },
                        'className': 'text-right',
                        "targets": 2,
                        "orderable": true
                    },
                    {
                        "render": function(data, type, row) {
                            return number_format(row['SalesPrice'], 2, ',', '.');
                        },
                        'className': 'text-right',
                        "targets": 3,
                        "orderable": true
                    },
                    {
                        "render": function(data, type, row) {
                            var select_btn = `<button class="btn btn-primary btn-xs" type="button" 
                            data-itemcode="${row['ItemCode']}"
                            data-itemname="${row['ItemName']}"
                            data-unitprice="${row['PurchasePrice']}"
                            data-sellingprice="${row['SalesPrice']}"
                            data-uom="${row['Uom']}"
                            onclick="selectLookupUrl(this)"
                            ><i class=""></i>Select</button>`;
                            return select_btn;
                        },
                        'className': 'text-center',
                        "targets": 5,
                        "orderable": false
                    },
                ],
                'columns': [
                    {
                        data: 'ItemCode'
                    },
                    {
                        data: 'ItemName'
                    },
                    {
                        data: 'PurchasePrice'
                    },
                    {
                        data: 'SalesPrice'
                    },
                    {
                        data: 'Uom'
                    },
                    {
                        defaultContent: ''
                    }
                ],
                order: [
                    [1, 'asc']
                ],
                initComplete: function() {},
                drawCallback: function(settings) {
                    $('.browseBtn').ladda('stop');
                    $('.row-elipsis').ellipsis().tooltip();
                },
                buttons: [{
                        extend: 'copy'
                    }
                ],
            });
});

function refreshDataTable() {
	$('#listDataTableProduct').DataTable().ajax.reload(null, false);
}
</script>