<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Coal_getting_inbound_stockroom extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('coal_getting_inbound_model');
		$this->load->model('master/stockroom_model');
		$this->load->model('master/vendor_model');
		$this->bc->set_title('Coal Getting Inbound Stockroom');
		$this->bc->add('Coal Getting',base_url().'coalgetting');
		$this->bc->add('Inbound',base_url().'coalgetting/coal_getting_inbound_stokroom');
	}
	
	public function index()
	{
		$data = array(
			'content' => 'inbound/main_inbound'
		);
		$this->load->view('tpl',$data);
	}

	function save()
	{
		$coalget_number = $this->input->post('t_coal_get_number')?:'empty';

		$data = array();
		$data['stockroom_id'] 		= $this->input->post('t_stockroom_id');
		$data['vehicle_id'] 		= $this->input->post('t_vehicle_id');
		$data['vendor_id'] 			= $this->input->post('t_vendor_id');
		$vendor_data = $this->vendor_model->get(array("vendor_id" => $data['vendor_id']));
		$vendor_mis = $vendor_data['vendor_mis'];
		$data['vendor_mis'] 		= $vendor_mis;
		$data['vehicle_number'] 	= $this->input->post('t_vehicle_number');
		$data['coal_get_status']	= 2;
		$data['coal_get_date']		= getSQLDate($this->input->post('t_coal_get_date'));
		$data['coal_get_time']		= $this->input->post('t_coal_get_time');
		// $data['coal_get_date']		= date('Y-m-d');
		// $data['coal_get_time']		= date('H:i:s');
		$data['gross_weight'] 	 	= $this->input->post('t_gross_weight');
		$data['tare_weight'] 		= $this->input->post('t_tare_weight');
		$data['net_weight'] 		= $this->input->post('t_net_weight');
		$data['id_rec'] 		   = $this->input->post('t_id_rec');
		
		if ($coalget_number == 'empty') {
			$prefix =  date('y') . date('m')  . '.CGT.';
			$data['coal_get_number'] = $this->coal_getting_inbound_model->gen_transaction_number($prefix);
		} else {
			$data['coal_get_number'] = $coalget_number;
		}

		$this->db->trans_start();
		
		// simpan header
		$save = $this->coal_getting_inbound_model->save($data);
        if ($save){
            $upd_stock = array();
            $upd_stock['stockroom_id'] = $data['stockroom_id']; 
            $upd_stock['stockroom_mineratio'] = $data['net_weight']; 
            $this->stockroom_model->save($upd_stock);
        }

		$this->db->trans_complete();

		if ($this->db->trans_status() === false) {
			$this->db->trans_rollback();
			$error = $this->db->error();
			$this->error($error);
		} else {
			$this->db->trans_commit();
			$this->result['vid'] 	= encode($data['vehicle_id']);
			$this->result['trxnumber'] 	= $data['coal_get_number'];
			$this->result['trxdate'] 	= $data['coal_get_date'];
			$this->result['trxtime'] 	= $data['coal_get_time'];
			$this->success('Save Success');
		}
	}

	public function getDataCoalGettingInbound()
	{
		$post = $this->input->post();
		
        $where = array();
        $where['tbl.coal_get_number'] = $post['coal_get_num'];
		$this->coal_getting_inbound_model->set_where($where);

		$coal_get_in = $this->coal_getting_inbound_model->get_list_get($where);
		// echo $this->db->last_query();die;

        if (!$coal_get_in['coal_get_number']){
            $this->error('Nomor Coal Getting tidak ditemukan !');
        }

        $this->result['coalgetin'] = $coal_get_in;
        $this->success('ok');		
	}

	function print_doc_pdf()
	{
		$trx_num = $this->input->post('id');
				
		$where = array();
        $where['tbl.coal_get_number'] = $trx_num;
		$list_data = $this->coal_getting_inbound_model->get_list_get($where);

		$data = array(
			'content' 	=> 'inbound/print', 
			'list_data'	=> $list_data
		);
		
		$this->load->view($data['content'],$data); 
	}

}