<div class="wrapper wrapper-content">
    <div class="row">
        <div class="ibox float-e-margins">
            <div class="col-lg-12">
                <div class="ibox-title">
                    <span style="height: 25px;" class="label label-warning "><h5>COAL GETTING DASHBOARD</h5></span>
                </div>
                <div class="ibox-content">
                    <div class="row">
                        <form autocomplete="off" method="post" id="form_filter" class="form-horizontal">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="form-group" id="daterange">
                                        <label class="col-sm-2 control-label">Periode</label>    
                                        <div class="col-sm-8">
                                            <div class="input-daterange input-group col-sm-12" id="datepicker">
                                                <input id="filter_date_start" type="text" class="input-sm form-control" name="t_filter_date_start" value="01<?= date('-m-Y') ?>" />
                                                <span class="input-group-addon">to</span>
                                                <input id="filter_date_end" type="text" class="input-sm form-control" name="t_filter_date_end" value="<?= date('d-m-Y') ?>" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2">
                                            <button class="btn btn-success btn-xs" type="button" onclick="refreshData()"><i class="fa fa-search"></i> Refresh</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <!-- chart by day  -->
                                     <h5><strong>By Day</strong></h5>
                                     <div id="resultChartDay" ></div>
                                </div>                                
                            </div>
                            <div class="col-lg-6">
                                <div class="row"></div><br><br>
                                <div class="row">
                                    <!-- chart by month  -->
                                    <h5><strong>By Month</strong></h5>
                                    <div id="resultChartMonth" ></div>
                                </div>
                            </div>
                        </form>                         
                    </div>
                </div>
            </div>            
        </div>
    </div> <br>
    <div class="row">
        <div class="ibox float-e-margins">
            <div class="col-lg-4">
                <div class="ibox-title">
                    <h5>TOTAL</h5>
                </div>
                <div class="ibox-content">   
                    <div id="resultSummary" ></div>
                    <!-- <div class="row">
                        <div class="col-sm-3"><h4>Volume</h4></div>
                        <div class="col-sm-1"><h4>:</h4></div>
                        <div class="col-sm-3" style="text-align:right;"><h4>10.000</h4></div>
                        <div class="col-sm-3"><h4>Ton's</h4></div>
                    </div>
                    <div class="row">
                        <div class="col-sm-3"><h4>Productivity</h4></div>
                        <div class="col-sm-1"><h4>:</h4></div>
                        <div class="col-sm-3" style="text-align:right;"><h4>1000</h4></div>
                        <div class="col-sm-3"><h4>Ton's / days</h4></div>
                    </div> -->
                </div>
            </div>            
            <div class="col-lg-8">
                <div class="ibox-title">
                    <h5>GROWTH</h5>
                </div>
                <div class="ibox-content">
                    <h5>COAL GETTING (in Ton's)</h5>
                    <div id="resultTable" ></div>
                </div>
            </div>            
        </div>        
    </div>
</div>

<script>
    $(document).ready(function(){       
        loadChartDay();
        loadChartMonth();
        loadSummary();
        loadTable();
    });

    function loadChartDay(){
        var formData = $('#form_filter').serializeArray();
        $.ajax({
            url: site_url + "coalgetting_dash/load_chart_day",
            dataType: "html",
            type: "POST",
            data: formData,
            // data: {
            //     charttype:charttype
            // },
            success: function(result) {
                $('#resultChartDay').html(result);                
            }
        })
    };
    
    function loadChartMonth(){
        var formData = $('#form_filter').serializeArray();
        $.ajax({
            url: site_url + "coalgetting_dash/load_chart_month",
            dataType: "html",
            type: "POST",
            data: formData,
            // data: {
            //     charttype:charttype
            // },
            success: function(result) {
                $('#resultChartMonth').html(result);                
            }
        })
    };

    function loadSummary(){
        var formData = $('#form_filter').serializeArray();
        $.ajax({
            url: site_url + "coalgetting_dash/load_summary",
            dataType: "html",
            type: "POST",
            data: formData,
            success: function(result) {
                $('#resultSummary').html(result);                
            }
        })
    };

    function loadTable(){
        $.ajax({
            url: site_url + "coalgetting_dash/load_table",
            dataType: "html",
            type: "POST",
            data: {
                // ...params
            },
            success: function(result) {
                $('#resultTable').html(result);                
            }
        })
    };

    function refreshData(){
        loadChartDay();
        loadChartMonth();
        loadSummary();
        loadTable();
    }

    
</script>    
