<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Settings extends MY_Controller {

	function __construct()
	{
		parent::__construct();
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('master/operator_model');
		$this->load->model('master/operator_type_model');
		$this->load->model('master/operator_access_model');
		$this->load->model('main/image_upload_model');
	}
	
	public function index()
	{
		getMenuBoxed();
	}
	
	public function profile($is_profile=0,$id_operator=0)
	{
		$head = array();
		
		$head = $this->operator_model->get(array('idOperator'=>$id_operator));
		$this->operator_type_model->set_order(array('idOperatorType'=>'ASC'));
		$oprType = $this->operator_type_model->get_list();
		$list_unit_bisnis = $get_unit_bisnis->result_array();
		
		$images_list = getImageList($id_operator,1);
		$data = array(
			'head'	=>	$head
			,'oprType'	=>	$oprType->result_array()
			,'images_list'	=>	$images_list
			,'is_profile'	=>	$is_profile
			,'title'	=>	'Edit profile'
			,'content'	=>	'profile'
		);
		
		$this->load->view($data['content'],$data);
	}

	function getImagePath($img_type)
	{
		$img_folder = 'images/';
		if (!file_exists($img_folder)) {
			mkdir($img_folder);
			// mkdir($produk_folder, 0777, true);
			// chmod($produk_folder, $permit);
		}
		$img_folder = 'images/'.$img_type;
		if (!file_exists($img_folder)) {
			mkdir($img_folder);
			// mkdir($produk_folder, 0777, true);
			// chmod($produk_folder, $permit);
		}
		return $img_folder;
	}
	
	function uploadImages($id,$img_type)
	{
		$files			= $_FILES; 
		if(!$files)
		{
			$result['message']	= 'Failed, File Upload is empty`..!';
			header('Content-type: application/json');
			echo die(json_encode($result));
		}
		
		$files_upload	= $_FILES;
		$config['upload_path']          = $this->getImagePath($img_type);
		$config['allowed_types']        = 'gif|jpg|png|jpeg';
		$config['file_name']            = $files_upload['t_filepond']['name'];
		$config['overwrite']			= true;
		$config['max_size']             = 3072; // 3MB
		$exploded						= explode(".", $config['file_name']);
		$extension 						= end($exploded);
		$config['fileType']             = $extension; // 3MB
		$file 							= $files_upload['t_filepond']['tmp_name'];
		list($width, $height) 			= getimagesize($file);
		$this->image_upload_model->set_where(array('foreignId'=>$id,'imageType'=>$img_type));
		$this->image_upload_model->set_order(array('orderBy'=>'ASC'));
		$getFU		= $this->image_upload_model->get_list();
		$countFU	= $getFU->num_rows();
		
		$orderBy	= $countFU+1;
		foreach($getFU->result_array() as $key=>$row )
		{
			if(($key+1)!=($row['orderBy']))
			{
				$orderBy = $key+1;
				break;
			}
		}
		
		
		$data_file_upload	= array();
		$data_file_upload['idImages']			=	0;
		$data_file_upload['orderBy']			=	$orderBy;
		$data_file_upload['foreignId']			=	$id;
		$data_file_upload['serverName']			=	$files_upload['t_filepond']['name'];
		$data_file_upload['serverNameWithoutExt']=	pathinfo($files_upload['t_filepond']['name'], PATHINFO_FILENAME);
		$data_file_upload['type']				=	$files_upload['t_filepond']['type'];
		$data_file_upload['path']				=	$config['upload_path'];
		$data_file_upload['ext']				=	$extension;
		$data_file_upload['size']				=	$files_upload['t_filepond']['size'];
		$data_file_upload['width']				=	$width;
		$data_file_upload['height']				=	$height;
		$data_file_upload['imageType']			=	$img_type; // provider = 2
		$data_file_upload['uploadBy']			=	$this->session->userdata('idOperator');
		$data_file_upload['usedFor']			=	3;
		$data_file_upload['createTime']			=	date('Y-m-d H:i:s');
		$data_file_upload['lastUpdate']			=	date('Y-m-d H:i:s');
		
		$id_file_upload = $this->image_upload_model->saveTo($data_file_upload);
		// start resize
		// $this->load->library('image_lib');
		// $resize_height = 200;
		
		// $resize = array(
			// "height"       => $resize_height,
			// "quality"      => '100%',
			// "source_image" => $data_file_upload['serverName'],
			// "new_image"    => $data_file_upload['path'].'resized_'.$data_file_upload['serverName']
		// );
		
		// $resize['width'] = $width * ($resize_height / $height);
		
		// $this->image_lib->initialize($resize);
		// if (!$this->image_lib->resize())
		// echo($this->image_lib->display_errors());
	 
		// end resize
		if (!file_exists($config['upload_path'])) {
			// $old_umask = umask(0);
			mkdir($config['upload_path']);
			// umask($old_umask);
		}
		$this->load->library('upload', $config);
		// $old_umask = umask(0);
		$upload_image = $this->upload->initialize($config);
		if(!$this->upload->do_upload('t_filepond'))
		{
		header("HTTP/1.1 500 Internal server error");
			$result['message']	= $this->upload->display_errors();
			header('Content-type: application/json');
			echo die(json_encode($result));
		}
		
		chmod($config['upload_path'], 0755);
	}

	function removeImages()
	{
		$data['foreignId']		= $this->input->post('id');
		$server_name_wo_ext	= $this->input->post('file_name');
		$data['imageType']		= $this->input->post('img_type');

		$get_image	= $this->image_upload_model->get(array('serverNameWithoutExt'=>$server_name_wo_ext));
		$get_image_row = $get_image;
		globalRemoveImages($get_image_row['foreignId'],$get_image_row['imageType']);
		
	}

	function profileSave(){
		$data['idOperator'] 	= $this->input->post('t_id_operator')?:0;
		$is_profile 			= $this->input->post('is_profile');
		
		$data['email'] 	= validate_input($this->input->post('t_email'),
						array(
							'name'=>'email',
							'required'=>true,
							'type'=>'varchar'
						)
					);
		$data['phone'] 	= validate_input($this->input->post('t_phone'),
						array(
							'name'=>'phone',
							'required'=>true,
							'type'=>'varchar'
						)
					);
		$data['userName'] 	= validate_input($this->input->post('userName'),
						array(
							'name'=>'user name',
							'required'=>true,
							'type'=>'varchar'
						)
					);
		// $data['name'] 	= validate_input($this->input->post('t_name'),
		// 				array(
		// 					'name'=>'full name',
		// 					'required'=>true,
		// 					'type'=>'varchar'
		// 				)
		// 			);
		$pass1				 	= $this->input->post('t_password_1');
		$pass2				 	= $this->input->post('t_password_2');
		$data['lastUpdate'] 	= date('Y-m-d H:i:s');
		
		if($data['idOperator'] == 0)
		{
			$check_username = $this->operator_model->get(array('userName'=>$data['userName']));
			
			if($check_username['idOperator']!='')
			{
				$this->error('user name sudah dipakai');
			}
			
			$check_email = $this->operator_model->get(array('email'=>$data['email']));
			
			if($check_email['idOperator']!='')
			{
				$this->error('email sudah dipakai');
			}
			
			$check_phone = $this->operator_model->get(array('phone'=>$data['phone']));
			
			if($check_phone['idOperator']!='')
			{
				$this->error('no handphone sudah dipakai');
			}
			if(!$pass1)
			{
				$this->error('password belum di isi');
			}
			$datenow = date('Y-m-d H:i:s');
			$data['expiryDate']			= date('Y-m-d',strtotime(date("Y-m-d", strtotime($datenow)) . " +20 year"));
		}
		
		if($pass1)
		{
			if($pass1!=$pass2)
			{
				$this->error('password yang dimasukan tidak sama');
			}
			$data['passWord'] 	= md5($pass1);
		}
		
		$this->operator_model->save($data);
		
		$this->success('data berhasil disimpan');
	}
}